require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

kOffX = 20;

MakeDialog
{
    CDEPanelFail
    {
        name="epanelfinish",
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        
        enter_curve = "config/curves/fx_start.xml",
        exit_curve = "config/curves/fx_end.xml",
        
        Bitmap
        {
            x=kCenter,y=kCenter-1000,
            w=800,h=600,
            name="panel",
            alpha = 1,        
            
            Bitmap
            {
                name="infopanel",
                image="ui/levelover/levelover",
                x=kCenter,
                y=kCenter,

                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {-- text for level loss
                    x=100,
                    y=130,
                    w=250,--kMax-80,
                    h=kMax,
                    flags=kHAlignLeft+kVAlignTop,
                    label="endless_fail",
                },
                
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                -- number of served tables:
                CreateTextLeftAlign(kCenter+70,kCenter-10,"#"..GetString("tables_served",GetCustomersServedEndlessStr()),0,0),
                -- number of lost tables:
                CreateTextLeftAlign(kCenter+70,kCenter+10,"#"..GetString("tables_lost",GetCustomersLostEndlessStr()),0,0),

                SetStyle(CreateTextStyle(FontGame, 24, RedColor)),
                Text
                {-- text "Total:"
                    x=kCenter+70,y=kCenter+40,
                    flags=kHAlignLeft+kVAlignCenter,
                    label="totalscore",
                },
                
                SetStyle(CreateTextStyle(FontGame, 24, RedColor)),
                Text
                {-- total score value
                    x=kCenter+145,y=kCenter+40,
                    flags=kHAlignLeft+kVAlignCenter,
                    label=GetLevelScore(),
                },

                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter -15,
                    y=kCenter + 100,
                    name="tryagain",
                    default = true,
                    command=
                        function()
                            SetEndlessFinishlResult(0);
                            HideEndlessFailPanel();
                        end,
				    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
				    CreateText(2,2,"tryagain", 0, 0),
				    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
				    CreateText(0,0,"tryagain", 0, 0),
                },
                
                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter -15,
                    y=kCenter + 145,
                    name="highscores",
                    label="highscores",
                    command=
                        function()
                            -- Highscore
                            SetEndlessFinishlResult(2);
                            HideEndlessFailPanel();
                        end,
				    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
				    CreateText(2,2,"highscores", 0, 0),
				    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
				    CreateText(0,0,"highscores", 0, 0),
                },
            },

            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=kCenter -15,
                y=kCenter + 190,
                name="quit",
                default = true,
                command=
                    function()
                        SetEndlessFinishlResult(1);
                        HideEndlessFailPanel();
                    end,
			    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
			    CreateText(2,2,"quit", 0, 0),
			    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
			    CreateText(0,0,"quit", 0, 0),
            },
            
            Bitmap
            { -- unhappy flo picture
                name="fail",
                image="ui/levelover/flo_lose",
                x=kCenter-200,
                y=kCenter,
            },
        },
    },
}